<?php
// /impersonate.php
// Inicia la suplantación de un usuario

session_start();
require_once 'db.php';
require_once 'logger.php'; // <-- INCLUIDA: Función centralizada de logs

// --- 1. Verificación de Seguridad Inicial ---

// Solo un admin o fisio puede iniciar una suplantación
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['user_rol'], ['superadmin', 'fisio'])) {
    header('Location: dashboard.php?error=access_denied');
    exit;
}

// Si ya estamos suplantando, no podemos suplantar de nuevo.
if (isset($_SESSION['admin_origen_id'])) {
    header('Location: dashboard.php?error=already_impersonating');
    exit;
}

$admin_user_id = $_SESSION['user_id'];
$admin_user_rol = $_SESSION['user_rol'];
$admin_user_nombre = $_SESSION['user_nombre'];
$admin_user_apellido = $_SESSION['user_apellido'] ?? ''; // El apellido original

$target_id = (int)($_GET['id'] ?? 0);

// No puedes suplantarte a ti mismo
if ($target_id === 0 || $target_id === $admin_user_id) {
    header('Location: ' . ($_SERVER['HTTP_REFERER'] ?? 'users.php') . '?error=invalid_target');
    exit;
}

// --- 2. Obtener datos del usuario a suplantar ---
$stmt = $db->prepare("SELECT id, nombre, apellido, rol, status, is_archived FROM cuentas WHERE id = ?");
$stmt->execute([$target_id]);
$target_user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$target_user || $target_user['status'] !== 'activo' || $target_user['is_archived'] == 1) {
    header('Location: ' . ($_SERVER['HTTP_REFERER'] ?? 'users.php') . '?error=user_not_found');
    exit;
}

// --- 3. Restricciones de Suplantación ---
// Un 'fisio' no puede suplantar a otro 'fisio' ni a un 'superadmin'
if ($admin_user_rol === 'fisio') {
    if ($target_user['rol'] === 'fisio' || $target_user['rol'] === 'superadmin') {
        header('Location: ' . ($_SERVER['HTTP_REFERER'] ?? 'users.php') . '?error=suplant_not_allowed');
        exit;
    }
}
// Si es superadmin, tiene permiso (ya hemos comprobado que no se suplanta a sí mismo)

// --- 4. Guardar Sesión Original ---
$_SESSION['admin_origen_id'] = $admin_user_id;
$_SESSION['admin_origen_rol'] = $admin_user_rol;
$_SESSION['admin_origen_nombre'] = $admin_user_nombre;
$_SESSION['admin_origen_apellido'] = $admin_user_apellido;
$_SESSION['admin_origen_return_url'] = $_SERVER['HTTP_REFERER'] ?? 'users.php';


// ★★★ INICIO: REGISTRO DE AUDITORÍA CRÍTICO (A3: IMPERSONATE_START) - DELEGACIÓN COMPLETA ★★★
// Preparamos los detalles que el helper necesita, manteniendo el código limpio.
$target_detail = $target_user['nombre'] . ' ' . ($target_user['apellido'] ?? '') . ' (Rol: ' . $target_user['rol'] . ')';
$actor_username = $admin_user_nombre . ' ' . $admin_user_apellido;

// ⚡️ LLAMADA DELEGADA AL HELPER (A3) ⚡️
registrar_impersonate_start($db, $admin_user_id, $actor_username, $target_user['id'], $target_detail);
// ★★★ FIN: REGISTRO DE AUDITORÍA ★★★


// --- 5. Sobrescribir Sesión Actual ---
session_regenerate_id(true); // Regenerar ID de sesión por seguridad
$_SESSION['user_id'] = $target_user['id'];
$_SESSION['user_rol'] = $target_user['rol'];
$_SESSION['user_nombre'] = $target_user['nombre'];
$_SESSION['user_apellido'] = $target_user['apellido'];
$_SESSION['is_impersonating'] = true; // Bandera para UI

// --- 6. Redirección ---
$redirect_url = $target_user['rol'] === 'paciente' ? 'patient_dashboard.php' : 'dashboard.php';
header('Location: ' . $redirect_url);
exit;
