<?php
// /download_backup.php
// CORREGIDO PARA MySQL

session_start();

// 1. Verificar permisos (solo Superadmin)
if (!isset($_SESSION['user_id']) || !isset($_SESSION['user_rol']) || $_SESSION['user_rol'] !== 'superadmin') {
    http_response_code(403); // Forbidden
    die('Acceso denegado.');
}

// 2. Obtener y validar nombre de archivo
$filename = basename($_GET['file'] ?? ''); // basename() para evitar directory traversal
$backupDir = __DIR__ . '/_backups';
$filePath = $backupDir . '/' . $filename;

// ★★★ INICIO DE LA CORRECCIÓN ★★★
// Validaciones básicas del nombre para MySQL
if (empty($filename) || strpos($filename, 'db-backup-') !== 0 || !str_ends_with($filename, '.sql')) {
    http_response_code(400); // Bad Request
    die('Nombre de archivo MySQL inválido.');
}
// ★★★ FIN DE LA CORRECCIÓN ★★★

// 3. Comprobar si el archivo existe y es legible
if (!file_exists($filePath) || !is_readable($filePath)) {
    http_response_code(404); // Not Found
    die('Archivo de backup no encontrado o no accesible.');
}

// 4. Enviar cabeceras para forzar la descarga
header('Content-Description: File Transfer');
header('Content-Type: application/sql'); // Tipo más específico para SQL
header('Content-Disposition: attachment; filename="' . $filename . '"');
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');
header('Content-Length: ' . filesize($filePath));

// 5. Limpiar buffer de salida y enviar el archivo
ob_clean(); // Limpiar cualquier salida previa
flush();    // Asegurarse de que las cabeceras se envían
readfile($filePath);
exit; // Terminar script después de enviar el archivo

?>
